//C5 LCD,KBD & LED demo

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "c5_io.h"
#include "c5_properties.h"

//types
typedef unsigned char       u8;
typedef signed char         s8;
typedef unsigned short int  u16;
typedef signed short int    s16;
typedef unsigned long int   u32;
typedef signed long int     s32;

#define BAUDRATE                115200 //com port baudrate
#define TIMEOUT                 2000   //com timeout, ms
#define IN_BUFFER_SIZE          512    //com input buffer size
#define OUT_BUFFER_SIZE         512    //com output buffer size

unsigned char Com_Port_Number;

unsigned char IO_Frame[512];
unsigned char ADD, CMD, Nbyte;

unsigned char Left_Counter,
              Right_Counter,
              Up_Counter,
              Down_Counter,
              Enter_Counter;

char  str[32];
unsigned char LEDs;

int main(void)
{

  printf("Enter the C5 com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  if( !C5_Open( Com_Port_Number, BAUDRATE, TIMEOUT, IN_BUFFER_SIZE, OUT_BUFFER_SIZE) )
  {
    printf("Can't open port!\n");
    return 1;
  };

  if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_ENTER_RC_MODE, 0, IO_Frame ) )
  {
    printf("Transmite error! Command:CMD_ENTER_RC_MODE\n");
    return 1;
  };

  if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
  {
    printf("Receive or CRC error!  Command:CMD_ENTER_RC_MODE\n");
    return 1;
  };

  if( IO_Frame[0] != C5_ERR_NO )
  {
    printf("The charger should be in the root menu!\n");
    return 1;
  };

  printf("Use the C5 keyboard...\n...or press any key(pc keyboard) for exit.\n");
  while( !_kbhit() )
  {
    //set LEDs
    //
    IO_Frame[0] = LEDs;
    Nbyte = 1;
    if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_RC_SET_LEDS, Nbyte, IO_Frame ) )
    {
      printf("Transmite error! Command:CMD_RC_SET_LEDS\n");
      return 0;
    };

    if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
    {
      printf("Receive or CRC error!  Command:CMD_RC_SET_LEDS\n");
      return 1;
    };

    //write lcd
    //
    // line 1
    sprintf(str,"%c:%2d; %c:%2d;     ",
            CHAR_UP, Up_Counter,
            CHAR_LEFT, Left_Counter);
    IO_Frame[0] = 0; //set x-coord.
    IO_Frame[1] = 0; //set y-coord.
    strcpy((char*)(IO_Frame+2), str); //copy str to frame
    Nbyte = strlen(str) + 2; //lenght of frame

    if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_RC_WRITE_LCD_XY, Nbyte, IO_Frame ) )
    {
      printf("(1)Transmite error! Command:CMD_RC_WRITE_XY\n");
      return 1;
    };

     if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
    {
      printf("(1)Receive or CRC error!  Command:CMD_RC_WRITE_XY\n");
      return 1;
    };

    if( IO_Frame[0] != C5_ERR_NO )
    {
      printf("(1)Command error!  Command:CMD_RC_WRITE_XY\n");
      return 1;
    };

    // line 2
    sprintf(str,"%c:%2d; %c:%2d; %c:%2d",
            CHAR_DOWN, Down_Counter,
            CHAR_RIGHT, Right_Counter,
            CHAR_ENTER, Enter_Counter);
    IO_Frame[0] = 0; //set x-coord.
    IO_Frame[1] = 1; //set y-coord.
    strcpy((char*)(IO_Frame+2), str); //copy str to frame
    Nbyte = strlen(str) + 2; //lenght of frame

    if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_RC_WRITE_LCD_XY, Nbyte, IO_Frame ) )
    {
      printf("(2)Transmite error! Command:CMD_RC_WRITE_XY\n");
      return 1;
    };

    if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
    {
      printf("(2)Receive or CRC error!  Command:CMD_RC_WRITE_XY\n");
      return 0;
    };

    if( IO_Frame[0] != C5_ERR_NO )
    {
      printf("(2)Command error!  Command:CMD_RC_WRITE_XY\n");
      return 1;
    };

    //get key
    //
    if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_RC_GET_KEY, 0, IO_Frame ) )
    {
      printf("Transmite error! Command:CMD_RC_GET_KEY\n");
      return 1;
    };

    if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
    {
      printf("Receive or CRC error!  Command:CMD_RC_GET_KEY\n");
      return 1;
    };

    switch( IO_Frame[0] )
    {
      case KEY_UP:
        LEDs = LED_CHARGE;
      case KEY_UP_RPT:
        Up_Counter++;
        if(Up_Counter > 99 )
	 Up_Counter = 0;
        break;

      case KEY_LEFT:
        LEDs = LED_DISCH;
      case KEY_LEFT_RPT:
        Left_Counter++;
        if(Left_Counter > 99 )
	 Left_Counter = 0;
        break;

      case KEY_DOWN:
        LEDs = LED_READY;
      case KEY_DOWN_RPT:
        Down_Counter++;
        if(Down_Counter > 99 )
	 Down_Counter = 0;
        break;

      case KEY_RIGHT:
        LEDs = LED_ERROR;
      case KEY_RIGHT_RPT:
        Right_Counter++;
        if(Right_Counter > 99 )
	 Right_Counter = 0;
        break;

      case KEY_ENTER:
        LEDs = PIEZO;
      case KEY_ENTER_RPT:
        Enter_Counter++;
        if(Enter_Counter > 99 )
	 Enter_Counter = 0;
        break;

      default:
        break;
    }

  };


  if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_RC_EXIT, 0, IO_Frame ) )
  {
    printf("Transmite error! Command:CMD_RC_EXIT\n");
    return 1;
  };

  if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
  {
    printf("Receive or CRC error!  Command:CMD_RC_EXIT\n");
    return 1;
  };

  if( IO_Frame[0] != C5_ERR_NO )
  {
    printf("Command error!  Command:CMD_RC_EXIT\n");
    return 1;
  };

  C5_Close();

  return 0;
}
