#ifndef _C5_PROPERTIES_H
#define _C5_PROPERTIES_H

//C5 address
#define C5_RX_ADDRESS		0

//info cmds
#define CMD_GET_DEVICE_NAME	10
#define CMD_GET_DEVICE_VERSION	11

//log data cmds
#define CMD_GET_SERVICE_INFO	12
#define CMD_GET_SERVICE_DATA	13

//set mode cmds
#define CMD_ENTER_DF_MODE	14
#define CMD_ENTER_RC_MODE	15

//read dataflash cmds
#define CMD_DF_EXIT		16
#define CMD_DF_GET_INFO		17
#define CMD_DF_PREPARE_DATA	18
#define CMD_DF_GET_DATA		19
#define CMD_DF_GET_DATA_BULK	20

//remote control cmds
#define CMD_RC_EXIT		21
#define CMD_RC_START_CHARGE	22
#define CMD_RC_START_DISCHARGE	23
#define CMD_RC_STOP_SERVICE	24
#define CMD_RC_GET_SERVICE_DATA	25
#define CMD_RC_WRITE_LCD_XY	26
#define CMD_RC_SET_LEDS		27
#define CMD_RC_GET_KEY		28

//remote control errors
#define C5_ERR_NO               0   //no error
#define C5_ERR_BUSY             1   //device busy
#define C5_ERR_NOT_READY        2   //device not ready
#define C5_ERR_PARAMETERS       3   //parameters value error
#define C5_ERR_NO_REPLY         4   //no reply
#define C5_ERR_MAX_POWER        5   //max. power exceeded
#define C5_ERR_OVERHEATING      6   //device overheating

//accu type
#define TYPE_NICD		1
#define TYPE_NIMH		2
#define TYPE_PB			3
#define TYPE_LI_ION		4
#define TYPE_LI_POLYMER		5
#define TYPE_LI_FEPO4		6

#define ACCU_TYPE_MAX		6

//programs
#define PGM_CHARGE		1 // charge
#define PGM_DISCHARGE		2 // discharge
#define PGM_DC			3 // discharge-charge
#define PGM_CDC			4 // charge-discharge-charge
#define PGM_CYCLE		5 // cycle
#define PGM_FORMING		6 // forming

#define ACCU_PROGRAM_MAX	6

//DataFlash CMD's answers
#define DF_EMPTY		0
#define DF_MANUAL_CHARGE_DATA	1
#define DF_SERVICE_DATA		2

#define DF_END			0

enum DATA_FLASH_TYPE
{
  C5_DF_EMPTY=0,
  C5_DF_MANUAL_CHARGE_DATA=1,
  C5_DF_SERVICE_DATA=2
};

enum DEVICE_ACTIVITY
{
  C5_NO_ACTIVITY=0,
  C5_SERVICE_PAUSE=1,
  C5_SERVICE_RUNNING=2,
  C5_MANUAL_CHARGE_PAUSE=3,
  C5_MANUAL_CHARGE_RUNNING=4
};

enum REMOTE_STATE
{
  C5_REMOTE_NO_SERVICE = 0,
  C5_REMOTE_STARTING_CHARGE = 1,
  C5_REMOTE_CHARGE_SERVICE = 2,
  C5_REMOTE_STARTING_DISCHARGE = 3,
  C5_REMOTE_DISCHARGE_SERVICE = 4,
  C5_REMOTE_OVERHEATING = 5
};

#define REMOTE_TIMEOUT          10 //sec

//LED's
#define PIEZO			0x01
#define LED_CHARGE		0x02
#define LED_DISCH		0x04
#define LED_READY		0x08
#define LED_ERROR		0x10

//Keyboard
#define KEY_NULL	0
#define KEY_UP		1
#define KEY_LEFT	2
#define KEY_DOWN	3
#define KEY_RIGHT	4
#define KEY_ENTER	5

#define KEY_UP_RPT	KEY_UP+0x80
#define KEY_LEFT_RPT	KEY_LEFT+0x80
#define KEY_DOWN_RPT	KEY_DOWN+0x80
#define KEY_RIGHT_RPT	KEY_RIGHT+0x80
#define KEY_ENTER_RPT	KEY_ENTER+0x80

//LCD: ASCII numbers for user's chars
#define CHAR_UP		8
#define CHAR_LEFT	9
#define CHAR_DOWN	10
#define CHAR_RIGHT	11
#define CHAR_ENTER	12
#define CHAR_UPDOWN	13
#define CHAR_LR		14


//max & min values
#define ACCU_CURRENT_CHARGE_MAX		5000     //mA
#define ACCU_CURRENT_DISCHARGE_MAX	5000     //mA
#define ACCU_CURRENT_MIN		50       //mA
#define MAX_CHARGE_POWER		70       //Watt
#define MAX_DISCHARGE_POWER		30       //Watt
#define MAX_VOLTAGE_OUT                 38000    //mV
#define MIN_VOLTAGE_OUT                 100      //mV
#define MAX_VOLTAGE_DROP                4000     //mV

extern char *Accu_Type_Name[ACCU_TYPE_MAX];
extern char *Accu_Program_Name[ACCU_PROGRAM_MAX];

#endif

