#include <windows.h>
#include <stdio.h>
#include "c5_io.h"
#include "c5_properties.h"

#define BAUDRATE                115200 //com port baudrate
#define TIMEOUT                 2000   //com timeout, ms
#define IN_BUFFER_SIZE          512    //com input buffer size
#define OUT_BUFFER_SIZE         512    //com output buffer size

unsigned char Com_Port_Number;
unsigned char IO_Frame[512];
unsigned char ADD, CMD, Nbyte;

int main(void)
{

  printf("Enter the C5 com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  if( !C5_Open( Com_Port_Number, BAUDRATE, TIMEOUT, IN_BUFFER_SIZE, OUT_BUFFER_SIZE) )
  {
    printf("Can't open port!\n");
    return 1;
  };

  if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_GET_DEVICE_NAME, 0, IO_Frame ) )
  {
    printf("Transmite error! Command:CMD_GET_DEVICE_NAME\n");
    return 1;
  };

  if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
  {
    printf("Receive or CRC error! Command:CMD_GET_DEVICE_NAME\n");
    return 1;
  };

  IO_Frame[Nbyte] = 0; //end of name string
  printf("Device Name:%s;\n", IO_Frame);

  if(  !C5_Send_Command( C5_RX_ADDRESS, CMD_GET_DEVICE_VERSION, 0, IO_Frame ) )
  {
    printf("Transmite error! Command:CMD_GET_DEVICE_VERSION\n");
    return 1;
  };

  if(  !C5_Get_Reply( &ADD, &CMD, &Nbyte, IO_Frame ) )
  {
    printf("Receive or CRC error! Command:CMD_GET_DEVICE_VERSION\n");
    return 1;
  };

  printf("Firmware: %u.%02u;\n", IO_Frame[1], IO_Frame[0]);


  C5_Close();
  return 0;
}

