#include "crc8.h"

//crc8 for a byte
void  CRC8(unsigned char b, unsigned char *crc)
{
  int i;
  
  for (i = 0; i < 8; i++)
  {
   if ( ((b ^ *crc) & 1) != 0)
     *crc = ((*crc ^ 0x18) >> 1) | 0x80;
   else *crc = (*crc >> 1) & ~0x80;

   b = b >> 1;
  }
}

//crc8 for a buffer
unsigned char CRC8_buff(void *buff, unsigned char count)
{
  unsigned char *p=(unsigned char*)(buff);
  unsigned char crc=CRC_INIT;

  while(count--)
    CRC8(*p++, &crc);

  return crc;
}

