#ifndef _C5_IO_H
#define _C5_IO_H

#include <windows.h>

#define FEND	0xC0 //Frame END
#define FESC	0xDB //Frame ESCape
#define TFEND	0xDC //Transposed Frame END
#define TFESC	0xDD //Transposed Frame ESCape

#ifdef _C5_IO_EXPORT_
#define C5_IO_API  __declspec(dllexport)
#else
#define C5_IO_API  __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif

C5_IO_API BOOL WINAPI C5_Open( unsigned char comport,
                               unsigned long baudrate,
                               unsigned long timeout,
                               unsigned long in_buffer_size,
                               unsigned long out_buffer_size );
C5_IO_API BOOL WINAPI C5_Close(void);
C5_IO_API BOOL WINAPI C5_Set_Timeout( unsigned long timeout );
C5_IO_API BOOL WINAPI C5_Purge(void);
C5_IO_API BOOL WINAPI C5_Flush(void);
C5_IO_API BOOL WINAPI C5_Send_Command(unsigned char ADDR, unsigned char CMD,
                                      unsigned char N, unsigned char *Data);
C5_IO_API BOOL WINAPI C5_Get_Reply(unsigned char *ADD, unsigned char *CMD,
                                   unsigned char *N, unsigned char *Data);

#ifdef __cplusplus
}
#endif

#endif /* _C5_IO_H */
