#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include "hb627.h"

#define TIMEOUT             5000 //ms

unsigned char Com_Port_Number, Error;
unsigned int ticks_save, ticks_curr, meas_counter;
short int U[8];

int main(void)
{

  printf("Enter the HB627 com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  //open com port
  if( !HB627_Open( Com_Port_Number, TIMEOUT ) )
  {
    printf("Can't open port!\n");
    return 1;
  }

  printf("\n\r");

  ticks_save = GetTickCount(); 
  while(1)
  {

    if( HB627_Read_All_Channel(U, &Error) )
    {
      meas_counter++;
    }
    else
    {
      printf("Error: %d;\n", Error);
      break;
    }

    ticks_curr = GetTickCount(); 
    if( (ticks_curr - ticks_save) >= 1000 )
    {
      printf("Measuremnt speed(cmd=c09): %d meas/sec\n\r", meas_counter);
      meas_counter = 0;
      ticks_save = GetTickCount(); 
    }
  }

  HB627_Close();
  return 0;
}
