#include <windows.h>
#include <winuser.h>
#include <stdio.h>
#include <conio.h>
#include "hb627.h"

#define TIMEOUT             5000 //ms
#define POLLING_INTERVAL    1000 //ms

unsigned char Com_Port_Number, Channel_Number, Error;
short int U[8];

BOOL Loop = TRUE;

UINT idTimer;
MSG msg;

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

int main(void)
{

  printf("Enter the HB627 com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  //open com port
  if( !HB627_Open( Com_Port_Number, TIMEOUT ) )
  {
    printf("Can't open port!\n");
    return 1;
  }

  printf("\n\r");

  //start timer
  idTimer = SetTimer(NULL, 0, POLLING_INTERVAL, (TIMERPROC) TimerProc);
  if(  !idTimer )
  {
    printf("Can't start timer!");
    return 1;
  }

  while(Loop)
  {

    GetMessage(&msg, NULL, 0, 0);
    DispatchMessage(&msg);

    if( _kbhit() )
      Loop = FALSE;

  }

  KillTimer(NULL, idTimer);
  HB627_Close();
  return 0;
}

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
  for(Channel_Number=1; Channel_Number<9; Channel_Number++)
  {
    if( !HB627_Read_Channel(Channel_Number, &U[Channel_Number-1], &Error) )
    {
      printf("Error: %d;\n", Error);
      Loop = FALSE;
      return;
    }
  }

  printf("Voltage(1..8), mV: %4d; %4d; %4d; %4d; %4d; %4d; %4d; %4d;\n",
         U[0], U[1], U[2], U[3], U[4], U[5], U[6], U[7], U[8]
        );

}
