#ifndef _HB627_H_
#define _HB627_H_

#include <windows.h>

#define ERR_NO		0 // no error
#define ERR_TX		1 // Tx error
#define ERR_RX		2 // Rx error
#define ERR_CS		3 // control sum error
#define ERR_PARAM	4 // parameters value error


#ifdef _HB627_EXPORT_
#define HB627_API  __declspec(dllexport)
#else
#define HB627_API  __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif

HB627_API BOOL WINAPI HB627_Open( unsigned char comport, long timeout );
HB627_API BOOL WINAPI HB627_Close(void);
HB627_API BOOL WINAPI HB627_Read_Channel( unsigned char channel, short int* result, unsigned char* error);
HB627_API BOOL WINAPI HB627_Read_All_Channel( short int* Result_Array, unsigned char* error );

#ifdef __cplusplus
}
#endif

#endif /* _HB627_H_ */
