#ifndef _USB_ADC_H_
#define _USB_ADC_H_

#include <windows.h>

#define ERR_NO		0 // no error
#define ERR_TX		1 // Tx error
#define ERR_RX		2 // Rx error
#define ERR_CS		3 // control sum error
#define ERR_PARAM	4 // parameters value error


#ifdef _USB_ADC_EXPORT_
#define USB_ADC_API  __declspec(dllexport)
#else
#define USB_ADC_API  __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif

USB_ADC_API BOOL WINAPI Open_USB_ADC( unsigned char comport, long baudrate, long timeout );
USB_ADC_API BOOL WINAPI Close_USB_ADC(void);
USB_ADC_API BOOL WINAPI Read_Channel( unsigned char channel, short int* result, unsigned char* error);
USB_ADC_API BOOL WINAPI Read_All_Channel( short int* Result_Array, unsigned char* error );

#ifdef __cplusplus
}
#endif

#endif /* _USB_ADC_H_ */
