#include <windows.h>
#include <winuser.h>
#include <stdio.h>
#include <conio.h>
#include "usb_adc.h"

#define BAUDRATE            115200
#define TIMEOUT             2000 //ms
#define POLLING_INTERVAL    1000 //ms

unsigned char Com_Port_Number, Error;
unsigned short int U[8];

BOOL Loop = TRUE;

UINT idTimer;
MSG msg;

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

int main(void)
{

  printf("Enter the USB ADC com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  //open com port
  if( !Open_USB_ADC( Com_Port_Number, BAUDRATE, TIMEOUT ) )
  {
    printf("Can't open port!\n");
    return 1;
  }

  //start timer
  idTimer = SetTimer(NULL, 0, POLLING_INTERVAL, (TIMERPROC) TimerProc);
  if(  !idTimer )
  {
    printf("Can't start timer!");
    return 1;
  }

  while(Loop)
  {

    GetMessage(&msg, NULL, 0, 0);
    DispatchMessage(&msg);

    if( _kbhit() )
      Loop = FALSE;

  }

  KillTimer(NULL, idTimer);
  Close_USB_ADC();
  return 0;
}

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
  if( Read_All_Channel(U, &Error) )
  {
    printf("U1=%4dmV; U2=%4dmV; U3=%4dmV; U4=%4dmV;\n", U[0], U[1], U[2], U[3]);
    printf("U5=%4dmV; U6=%4dmV; U7=%4dmV; U8=%4dmV;\n\n", U[4], U[5], U[6], U[7]);
  }
  else
  {
    printf("Error: %d;\n", Error);
    Loop = FALSE;        
  }
}
