#include <windows.h>
#include <winuser.h>
#include <stdio.h>
#include <conio.h>
#include "usb_adc.h"

#define BAUDRATE            115200
#define TIMEOUT             2000 //ms
#define POLLING_INTERVAL    1000 //ms

unsigned char Com_Port_Number, Channel_Number, Error;
unsigned short int U;

BOOL Loop = TRUE;

UINT idTimer;
MSG msg;

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

int main(void)
{

  printf("Enter the USB ADC com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  printf("Enter the ADC-channel number(1..8):");
  scanf("%d", &Channel_Number);

  //open com port
  if( !Open_USB_ADC( Com_Port_Number, BAUDRATE, TIMEOUT ) )
  {
    printf("Can't open port!\n");
    return 1;
  }


  //start timer
  idTimer = SetTimer(NULL, 0, POLLING_INTERVAL, (TIMERPROC) TimerProc);
  if(  !idTimer )
  {
    printf("Can't start timer!");
    return 1;
  }

  while(Loop)
  {

    GetMessage(&msg, NULL, 0, 0);
    DispatchMessage(&msg);

    if( _kbhit() )
      Loop = FALSE;

  }

  KillTimer(NULL, idTimer);
  Close_USB_ADC();
  return 0;
}

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
  if( Read_Channel(Channel_Number, &U, &Error) )
  {
    printf("U = %dmV;\n", U);
  }
  else
  {
    printf("Error: %d;\n", Error);
    Loop = FALSE;
  }
}

