VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "HB625 - Bluetooth Data Acquisition Module(Digital Output Demo)"
   ClientHeight    =   2730
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7440
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2730
   ScaleWidth      =   7440
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame frameDigital 
      Caption         =   "Digital Outputs"
      Height          =   1335
      Left            =   360
      TabIndex        =   5
      Top             =   1080
      Width           =   6735
      Begin VB.CheckBox Digital 
         Caption         =   "8"
         Enabled         =   0   'False
         Height          =   615
         Index           =   7
         Left            =   6120
         TabIndex        =   13
         Top             =   360
         Width           =   495
      End
      Begin VB.CheckBox Digital 
         Caption         =   "7"
         Enabled         =   0   'False
         Height          =   615
         Index           =   6
         Left            =   5280
         TabIndex        =   12
         Top             =   360
         Width           =   495
      End
      Begin VB.CheckBox Digital 
         Caption         =   "6"
         Enabled         =   0   'False
         Height          =   615
         Index           =   5
         Left            =   4440
         TabIndex        =   11
         Top             =   360
         Width           =   495
      End
      Begin VB.CheckBox Digital 
         Caption         =   "5"
         Enabled         =   0   'False
         Height          =   615
         Index           =   4
         Left            =   3600
         TabIndex        =   10
         Top             =   360
         Width           =   375
      End
      Begin VB.CheckBox Digital 
         Caption         =   "4"
         Enabled         =   0   'False
         Height          =   615
         Index           =   3
         Left            =   2760
         TabIndex        =   9
         Top             =   360
         Width           =   495
      End
      Begin VB.CheckBox Digital 
         Caption         =   "3"
         Enabled         =   0   'False
         Height          =   615
         Index           =   2
         Left            =   1920
         TabIndex        =   8
         Top             =   360
         Width           =   495
      End
      Begin VB.CheckBox Digital 
         Caption         =   "2"
         Enabled         =   0   'False
         Height          =   615
         Index           =   1
         Left            =   1080
         TabIndex        =   7
         Top             =   360
         Width           =   495
      End
      Begin VB.CheckBox Digital 
         Caption         =   "1"
         Enabled         =   0   'False
         Height          =   615
         Index           =   0
         Left            =   240
         TabIndex        =   6
         Top             =   360
         Width           =   495
      End
   End
   Begin VB.Timer tmrPolling 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   1200
      Top             =   360
   End
   Begin VB.CommandButton btnStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   495
      Left            =   3720
      TabIndex        =   4
      Top             =   360
      Width           =   1575
   End
   Begin VB.CommandButton btnQuit 
      Caption         =   "Quit"
      Height          =   495
      Left            =   5520
      TabIndex        =   3
      Top             =   360
      Width           =   1575
   End
   Begin VB.CommandButton btnStart 
      Caption         =   "Start"
      Height          =   495
      Left            =   1800
      TabIndex        =   2
      Top             =   360
      Width           =   1575
   End
   Begin VB.TextBox txtComPort 
      Height          =   285
      Left            =   360
      TabIndex        =   0
      Text            =   "1"
      Top             =   480
      Width           =   615
   End
   Begin VB.Label lblComPort 
      Caption         =   "ComPort Number"
      Height          =   255
      Left            =   360
      TabIndex        =   1
      Top             =   120
      Width           =   1335
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit
Private OutputByte As Byte


Private Sub btnQuit_Click()
    
  Close_HB625
  End
  
End Sub

Private Sub BtnStart_Click()

Dim Error As Byte
Dim i As Integer

  If Open_HB625(CByte(Val(txtComPort.Text)), 9600, 5000) Then
    
    OutputByte = 0
    If Set_Digital_Output(OutputByte, Error) = False Then
      Reset
      Display_Error (Error)
    End If
    
    For i = 0 To 7
      Digital(i).Enabled = True
    Next
    
    btnStart.Enabled = False
    btnStop.Enabled = True
    tmrPolling.Enabled = True
  
  Else
    MsgBox "Can't open comport!", vbOKOnly, "Error"
  End If
  
End Sub
Private Sub Reset()

Dim i As Integer
    
    For i = 0 To 7
      Digital(i).Enabled = False
      Digital(i).Value = 0
    Next
    OutputByte = 0
    btnStart.Enabled = True
    btnStop.Enabled = False
    tmrPolling.Enabled = False
    Close_HB625
    
End Sub

Private Sub btnStop_Click()

    Reset
    
End Sub
Private Sub Display_Error(ByVal Error As Byte)

Dim ErrMsg As String
  
  Select Case Error
    Case Err_No
      ErrMsg = "No error"
    Case ERR_TX
      ErrMsg = "Tx error"
    Case ERR_RX
      ErrMsg = "Rx error"
    Case ERR_CS
      ErrMsg = "Control sum error"
    Case ERR_PARAM
      ErrMsg = "Parameters value error"
  End Select
    
  MsgBox ErrMsg, vbOKOnly, "Error"
    
End Sub

Private Sub tmrPolling_Timer()

Dim Error As Byte
Dim i As Byte
    
  For i = 0 To 7
    If Digital(i).Value = 1 Then
      OutputByte = OutputByte Or (2 ^ i)
    Else
      OutputByte = OutputByte And (Not (2 ^ i))
    End If
  Next
  If Set_Digital_Output(OutputByte, Error) = False Then
    Reset
    Display_Error (Error)
  End If
  
End Sub
