#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include "hb625.h"

#define BAUDRATE            9600
#define TIMEOUT             5000 //ms

unsigned char Com_Port_Number, Error, meas_counter;
unsigned int ticks_save, ticks_curr;
short int U[8];

int main(void)
{

  printf("Enter the HB625 com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  //open com port
  if( !Open_HB625( Com_Port_Number, BAUDRATE, TIMEOUT ) )
  {
    printf("Can't open port!\n");
    return 1;
  }

  printf("\n\r");

  ticks_save = GetTickCount(); 
  while(1)
  {

    if( Read_All_Channel(U, &Error) )
    {
      meas_counter++;
    }
    else
    {
      printf("Error: %d;\n", Error);
      break;
    }

    if( _kbhit() )
      break;

    ticks_curr = GetTickCount(); 
    if( (ticks_curr - ticks_save) >= 1000 )
    {
      printf("Measurement speed(cmd=c09): %d meas/sec\n\r", meas_counter);
      meas_counter = 0;
      ticks_save = GetTickCount(); 
    }
  }

  Close_HB625();
  return 0;
}
