#include <windows.h>
#include <winuser.h>
#include <stdio.h>
#include <conio.h>
#include "hb625.h"

#define BAUDRATE            9600
#define TIMEOUT             5000 //ms
#define POLLING_INTERVAL    1000 //ms

unsigned char Com_Port_Number, Error, channel;

BOOL Loop = TRUE;

UINT idTimer;
MSG msg;

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

int main(void)
{

  printf("Enter the HB625 com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  //open com port
  if( !Open_HB625( Com_Port_Number, BAUDRATE, TIMEOUT ) )
  {
    printf("Can't open port!\n");
    return 1;
  }

  printf("\n\r");

  //start timer
  idTimer = SetTimer(NULL, 0, POLLING_INTERVAL, (TIMERPROC) TimerProc);
  if(  !idTimer )
  {
    printf("Can't start timer!");
    return 1;
  }

  while(Loop)
  {

    GetMessage(&msg, NULL, 0, 0);
    DispatchMessage(&msg);

    if( _kbhit() )
      Loop = FALSE;

  }

  KillTimer(NULL, idTimer);
  Close_HB625();
  return 0;
}

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
  if( Set_Digital_Output((1<<channel), &Error) )
  {
    printf("Digital output N%1d is ON;\r", channel+1);
	if( channel < 7)
	  channel++;
    else
	  channel = 0;
  }
  else
  {
    printf("\n\rError: %d;\n", Error);
    Loop = FALSE;
  }
}
