#ifndef _HB625_H_
#define _HB625_H_

#include <windows.h>

#define ERR_NO		0 // no error
#define ERR_TX		1 // Tx error
#define ERR_RX		2 // Rx error
#define ERR_CS		3 // control sum error
#define ERR_PARAM	4 // parameters value error


#ifdef _HB625_EXPORT_
#define HB625_API  __declspec(dllexport)
#else
#define HB625_API  __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif

HB625_API BOOL WINAPI Open_HB625( unsigned char comport, long baudrate, long timeout );
HB625_API BOOL WINAPI Close_HB625(void);
HB625_API BOOL WINAPI Read_All_Channel( short int* Result_Array, unsigned char* error );
HB625_API BOOL WINAPI Set_Digital_Output( unsigned char out, unsigned char* error );

#ifdef __cplusplus
}
#endif

#endif /* _HB625_H_ */
