#include <windows.h>
#include <winuser.h>
#include <stdio.h>
#include <conio.h>
#include "hb625.h"

#define BAUDRATE            9600
#define TIMEOUT             5000 //ms
#define POLLING_INTERVAL    1000 //ms

unsigned char Com_Port_Number, Error;
short int U[8];

BOOL Loop = TRUE;

UINT idTimer;
MSG msg;

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

int main(void)
{

  printf("Enter the HB625 com port number(1..255):");
  scanf("%d", &Com_Port_Number);

  //open com port
  if( !Open_HB625( Com_Port_Number, BAUDRATE, TIMEOUT ) )
  {
    printf("Can't open port!\n");
    return 1;
  }

  printf("\n\r");

  //start timer
  idTimer = SetTimer(NULL, 0, POLLING_INTERVAL, (TIMERPROC) TimerProc);
  if(  !idTimer )
  {
    printf("Can't start timer!");
    return 1;
  }

  while(Loop)
  {

    GetMessage(&msg, NULL, 0, 0);
    DispatchMessage(&msg);

    if( _kbhit() )
      Loop = FALSE;

  }

  KillTimer(NULL, idTimer);
  Close_HB625();
  return 0;
}

void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
  if( Read_All_Channel(U, &Error) )
  {
    printf("U1=%4dmV; U2=%4dmV; U3=%4dmV; U4=%4dmV;\n", U[0], U[1], U[2], U[3]);
    printf("U5=%4dmV; U6=%4dmV; U7=%4dmV; U8=%4dmV;\n\n", U[4], U[5], U[6], U[7]);
  }
  else
  {
    printf("Error: %d;\n", Error);
    Loop = FALSE;
  }
}
